/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.model.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.client.model.AbstractSolidEntityModel;
import dev.toma.gunsrpg.client.model.component.IOpticsProvider;
import dev.toma.gunsrpg.client.model.component.ScopeModel;
import dev.toma.gunsrpg.sided.ClientSideManager;
import java.util.function.Function;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractAttachmentModel
extends AbstractSolidEntityModel {
    public static final ResourceLocation GLASS_TEXTURE = GunsRPG.makeResource("textures/scope/glass.png");
    private static final int LIGHT = LightTexture.func_228451_a_((int)15, (int)15);

    public abstract void renderAttachment(MatrixStack var1, IRenderTypeBuffer var2, int var3, int var4, float var5);

    protected static void renderReflexSight(MatrixStack matrix, IRenderTypeBuffer buffer, IOpticsProvider provider, float progress, int light, int overlay) {
        IVertexBuilder modelVertexBuilder = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)provider.getComponentTextureMap()));
        provider.renderOptic(matrix, modelVertexBuilder, light, overlay);
        ResourceLocation path = provider.getReticleTextureProvider().get();
        Function<ResourceLocation, RenderType> renderTypeFunction = ScopeModel.isShaderCompatibilityMode() ? RenderType::func_228638_b_ : RenderType::func_239272_l_;
        IVertexBuilder reticleVertexBuilder = buffer.getBuffer(renderTypeFunction.apply(path));
        int reticleColor = provider.getReticleTintARGB();
        float cfgA = (float)(reticleColor >> 24 & 0xFF) / 255.0f;
        float a = ClientSideManager.config.alwaysRenderReticles ? 1.0f : Math.min(cfgA, progress);
        float r = (float)(reticleColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(reticleColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(reticleColor & 0xFF) / 255.0f;
        provider.getGlassModel().func_228309_a_(matrix, reticleVertexBuilder, LIGHT, overlay, r, g, b, a);
    }

    public static void renderScopeWithGlass(MatrixStack matrix, IRenderTypeBuffer buffer, IOpticsProvider provider, float progress, int light, int overlay) {
        float inv = 1.0f - progress;
        float sizeProgress = progress >= 0.9f ? progress : 0.0f;
        float sizeProgressInv = 1.0f - sizeProgress;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.0, (double)(0.78f * sizeProgress));
        matrix.func_227862_a_(1.0f, 1.0f, 0.07f + 0.93f * sizeProgressInv);
        IVertexBuilder modelVertexBuilder = buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)provider.getComponentTextureMap()));
        provider.renderOptic(matrix, modelVertexBuilder, light, overlay);
        Function<ResourceLocation, RenderType> renderTypeFunction = ScopeModel.isShaderCompatibilityMode() ? RenderType::func_228638_b_ : RenderType::func_239272_l_;
        ResourceLocation opticsTextureMap = provider.getReticleTextureProvider().get();
        IVertexBuilder reticleVertexBuilder = buffer.getBuffer(renderTypeFunction.apply(opticsTextureMap));
        provider.getGlassModel().func_228309_a_(matrix, reticleVertexBuilder, light, overlay, 1.0f, 1.0f, 1.0f, progress);
        IVertexBuilder overlayVertexBuilder = buffer.getBuffer(renderTypeFunction.apply(GLASS_TEXTURE));
        provider.getOverlayModel().func_228309_a_(matrix, overlayVertexBuilder, light, overlay, 0.0f, 0.0f, 0.0f, inv);
        matrix.func_227865_b_();
    }

    public static void setBuiltInRender(ModelRenderer render) {
        AbstractAttachmentModel.setBuiltInRender(render, 0.0f);
    }

    public static void setBuiltInRender(ModelRenderer render, float offset) {
        for (ModelRenderer.ModelBox box : render.field_78804_l) {
            for (ModelRenderer.TexturedQuad quad : box.field_78254_i) {
                ModelRenderer.PositionTextureVertex ver1 = quad.field_78239_a[0];
                ModelRenderer.PositionTextureVertex ver2 = quad.field_78239_a[1];
                ModelRenderer.PositionTextureVertex ver3 = quad.field_78239_a[2];
                ModelRenderer.PositionTextureVertex ver4 = quad.field_78239_a[3];
                float max = 1.0f - offset;
                AbstractAttachmentModel.setUV(ver1, max, offset);
                AbstractAttachmentModel.setUV(ver2, offset, offset);
                AbstractAttachmentModel.setUV(ver3, offset, max);
                AbstractAttachmentModel.setUV(ver4, max, max);
            }
        }
    }

    public final void func_225598_a_(MatrixStack matrix, IVertexBuilder vertexbuilder, int light, int overlay, float red, float green, float blue, float alpha) {
    }

    private static void setUV(ModelRenderer.PositionTextureVertex vertex, float u, float v) {
        vertex.field_78241_b = u;
        vertex.field_78242_c = v;
    }
}

